package com.ejie.ab04b.model;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.SituacionEntregaEnum;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Venviospostales generated by UDA, 04-sep-2017 14:27:39.
 * 
 * @author UDA
 */

public class Venviospostales implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private static final int NUMEXP_LPAD_SIZE = 5;
	private static final String NUMEXP_LPAD_CHAR = "0";

	// Clave compuesta
	private String tipoexp;
	private Long idTramite;
	private Long tipoTramite;
	private String territApertura;
	private String anoApertura;
	private Integer numApertura;
	private java.util.Date fecRegistro;
	private Long idDatosEnvioPostal069;
	private Long idRemesa069;
	private String codRemesa069;
	private Long idColeccion069;
	private String codColeccion069;
	private Long idEnvio069;
	private String codEnvio069;
	private String codSituacionEnvio069;
	private String descSituacionEnvioEs069;
	private String descSituacionEnvioEu069;
	private String estadoEnvio069;
	private String descEstadoEnvioEs;
	private String descEstadoEnvioEu;
	private java.util.Date fecnotificacion069;
	private java.util.Date fecSituacionEnvio069;
	private java.util.Date fecacuse069;
	private Long idTramite089;
	private String descripcionEs089;
	private String descripcionEu089;
	private Integer codDatosNotif066;
	private Integer codLocalizacion067;
	private String descProvincia;
	private String descMunicipio;
	private String descLocalidad;
	private String calle067;
	private String portal067;
	private String codpostal067;
	private String piso067;
	private String puerta067;

	private Tramite tramite;
	private ComunicacionApertura apertura;
	private OS2 os2;
	private OS3 os3;
	private DatosEnvioPostal datosEnvioPostal;
	private DatosNotificacion datosNotifEnvio;

	private boolean esSituacionFinal;
	private Boolean esEnvioCorrecto;

	private Date fecRegistroDesde;
	private Date fecRegistroHasta;

	private Integer[] estadosComunicaciones;
	private String[] tiposexp;

	private String oid;

	/**
	 * Method 'Venviospostales'.
	 */
	public Venviospostales() {
	}

	/**
	 * Method 'Venviospostales'.
	 * 
	 * tipoexp String idTramite Long
	 *
	 * @param tipoexp
	 *            the tipoexp
	 * @param idTramite
	 *            the id tramite
	 */
	public Venviospostales(String tipoexp, Long idTramite) {
		this.tipoexp = tipoexp;
		this.idTramite = idTramite;
	}

	/**
	 * Method 'Venviospostales'.
	 * 
	 * tipoexp String idTramite Long tipoTramite Long territApertura String
	 * anoApertura String numApertura Integer fecRegistro Date
	 * idDatosEnvioPostal069 Long idRemesa069 Long codRemesa069 String
	 * idColeccion069 Long codColeccion069 String idEnvio069 Long codEnvio069
	 * String codSituacionEnvio069 String descSituacionEnvioEs069 String
	 * descSituacionEnvioEu069 String estadoEnvio069 String descEstadoEnvioEs
	 * String descEstadoEnvioEu String fecnotificacion069 Date
	 * fecSituacionEnvio069 Date fecacuse069 Date idTramite089 Long
	 * descripcionEs089 String descripcionEu089 String codDatosNotif066 Integer
	 * codLocalizacion067 Integer descProvincia String descMunicipio String
	 * descLocalidad String calle067 String portal067 String codpostal067 String
	 * piso067 String puerta067 String oid the oid
	 *
	 * @param tipoexp
	 *            the tipoexp
	 * @param idTramite
	 *            the id tramite
	 * @param tipoTramite
	 *            the tipo tramite
	 * @param territApertura
	 *            the territ apertura
	 * @param anoApertura
	 *            the ano apertura
	 * @param numApertura
	 *            the num apertura
	 * @param fecRegistro
	 *            the fec registro
	 * @param idDatosEnvioPostal069
	 *            the id datos envio postal 069
	 * @param idRemesa069
	 *            the id remesa 069
	 * @param codRemesa069
	 *            the cod remesa 069
	 * @param idColeccion069
	 *            the id coleccion 069
	 * @param codColeccion069
	 *            the cod coleccion 069
	 * @param idEnvio069
	 *            the id envio 069
	 * @param codEnvio069
	 *            the cod envio 069
	 * @param codSituacionEnvio069
	 *            the cod situacion envio 069
	 * @param descSituacionEnvioEs069
	 *            the desc situacion envio es 069
	 * @param descSituacionEnvioEu069
	 *            the desc situacion envio eu 069
	 * @param estadoEnvio069
	 *            the estado envio 069
	 * @param descEstadoEnvioEs
	 *            the desc estado envio es
	 * @param descEstadoEnvioEu
	 *            the desc estado envio eu
	 * @param fecnotificacion069
	 *            the fecnotificacion 069
	 * @param fecSituacionEnvio069
	 *            the fec situacion envio 069
	 * @param fecacuse069
	 *            the fecacuse 069
	 * @param idTramite089
	 *            the id tramite 089
	 * @param descripcionEs089
	 *            the descripcion es 089
	 * @param descripcionEu089
	 *            the descripcion eu 089
	 * @param codDatosNotif066
	 *            the cod datos notif 066
	 * @param codLocalizacion067
	 *            the cod localizacion 067
	 * @param descProvincia
	 *            the desc provincia
	 * @param descMunicipio
	 *            the desc municipio
	 * @param descLocalidad
	 *            the desc localidad
	 * @param calle067
	 *            the calle 067
	 * @param portal067
	 *            the portal 067
	 * @param codpostal067
	 *            the codpostal 067
	 * @param piso067
	 *            the piso 067
	 * @param puerta067
	 *            the puerta 067
	 * @param oid
	 *            the oid
	 */
	public Venviospostales(String tipoexp, Long idTramite, Long tipoTramite,
			String territApertura, String anoApertura, Integer numApertura,
			Date fecRegistro, Long idDatosEnvioPostal069, Long idRemesa069,
			String codRemesa069, Long idColeccion069, String codColeccion069,
			Long idEnvio069, String codEnvio069, String codSituacionEnvio069,
			String descSituacionEnvioEs069, String descSituacionEnvioEu069,
			String estadoEnvio069, String descEstadoEnvioEs,
			String descEstadoEnvioEu, Date fecnotificacion069,
			Date fecSituacionEnvio069, Date fecacuse069, Long idTramite089,
			String descripcionEs089, String descripcionEu089,
			Integer codDatosNotif066, Integer codLocalizacion067,
			String descProvincia, String descMunicipio, String descLocalidad,
			String calle067, String portal067, String codpostal067,
			String piso067, String puerta067, String oid) {
		this.tipoexp = tipoexp;
		this.idTramite = idTramite;
		this.tipoTramite = tipoTramite;
		this.territApertura = territApertura;
		this.anoApertura = anoApertura;
		this.numApertura = numApertura;
		this.fecRegistro = fecRegistro;
		this.idDatosEnvioPostal069 = idDatosEnvioPostal069;
		this.idRemesa069 = idRemesa069;
		this.codRemesa069 = codRemesa069;
		this.idColeccion069 = idColeccion069;
		this.codColeccion069 = codColeccion069;
		this.idEnvio069 = idEnvio069;
		this.codEnvio069 = codEnvio069;
		this.codSituacionEnvio069 = codSituacionEnvio069;
		this.descSituacionEnvioEs069 = descSituacionEnvioEs069;
		this.descSituacionEnvioEu069 = descSituacionEnvioEu069;
		this.estadoEnvio069 = estadoEnvio069;
		this.descEstadoEnvioEs = descEstadoEnvioEs;
		this.descEstadoEnvioEu = descEstadoEnvioEu;
		this.fecnotificacion069 = fecnotificacion069;
		this.fecSituacionEnvio069 = fecSituacionEnvio069;
		this.fecacuse069 = fecacuse069;
		this.idTramite089 = idTramite089;
		this.descripcionEs089 = descripcionEs089;
		this.descripcionEu089 = descripcionEu089;
		this.codDatosNotif066 = codDatosNotif066;
		this.codLocalizacion067 = codLocalizacion067;
		this.descProvincia = descProvincia;
		this.descMunicipio = descMunicipio;
		this.descLocalidad = descLocalidad;
		this.calle067 = calle067;
		this.portal067 = portal067;
		this.codpostal067 = codpostal067;
		this.piso067 = piso067;
		this.puerta067 = puerta067;
		this.oid = oid;
	}

	/**
	 * Method 'getTipoexp'.
	 * 
	 * String
	 *
	 * @return the tipoexp
	 */

	public String getTipoexp() {
		return this.tipoexp;
	}

	/**
	 * Method 'setTipoexp'.
	 * 
	 * tipoexp String
	 *
	 * @param tipoexp
	 *            the new tipoexp
	 */

	public void setTipoexp(String tipoexp) {
		this.tipoexp = tipoexp;
	}

	/**
	 * Method 'getIdTramite'.
	 * 
	 * Long
	 *
	 * @return the id tramite
	 */

	public Long getIdTramite() {
		return this.idTramite;
	}

	/**
	 * Method 'setIdTramite'.
	 * 
	 * idTramite Long
	 *
	 * @param idTramite
	 *            the new id tramite
	 */

	public void setIdTramite(Long idTramite) {
		this.idTramite = idTramite;
	}

	/**
	 * Method 'getTipoTramite'.
	 * 
	 * Long
	 *
	 * @return the tipo tramite
	 */

	public Long getTipoTramite() {
		return this.tipoTramite;
	}

	/**
	 * Method 'setTipoTramite'.
	 * 
	 * tipoTramite Long
	 *
	 * @param tipoTramite
	 *            the new tipo tramite
	 */

	public void setTipoTramite(Long tipoTramite) {
		this.tipoTramite = tipoTramite;
	}

	/**
	 * Method 'getTerritApertura'.
	 * 
	 * String
	 *
	 * @return the territ apertura
	 */

	public String getTerritApertura() {
		return this.territApertura;
	}

	/**
	 * Method 'setTerritApertura'.
	 * 
	 * territApertura String
	 *
	 * @param territApertura
	 *            the new territ apertura
	 */

	public void setTerritApertura(String territApertura) {
		this.territApertura = territApertura;
	}

	/**
	 * Method 'getAnoApertura'.
	 * 
	 * String
	 *
	 * @return the ano apertura
	 */
	public String getAnoApertura() {
		return this.anoApertura;
	}

	/**
	 * Method 'setAnoApertura'.
	 * 
	 * anoApertura String
	 *
	 * @param anoApertura
	 *            the new ano apertura
	 */

	public void setAnoApertura(String anoApertura) {
		this.anoApertura = anoApertura;
	}

	/**
	 * Method 'getNumApertura'.
	 * 
	 * Integer
	 *
	 * @return the num apertura
	 */

	public Integer getNumApertura() {
		return this.numApertura;
	}

	/**
	 * Method 'setNumApertura'.
	 * 
	 * numApertura Integer
	 *
	 * @param numApertura
	 *            the new num apertura
	 */

	public void setNumApertura(Integer numApertura) {
		this.numApertura = numApertura;
	}

	/**
	 * Gets the num expediente.
	 * 
	 * String
	 *
	 * @return the num expediente
	 */
	public String getNumExpediente() {
		StringBuilder sb = new StringBuilder();
		if (this.territApertura != null && this.anoApertura != null
				&& this.numApertura != null) {
			sb.append(this.territApertura);
			sb.append("/");
			sb.append(this.anoApertura);
			sb.append("/");
			sb.append(StringUtils.leftPad(this.numApertura.toString(),
					Venviospostales.NUMEXP_LPAD_SIZE,
					Venviospostales.NUMEXP_LPAD_CHAR));
		}
		return sb.toString();
	}

	/**
	 * Method 'getFecRegistro'.
	 * 
	 * Date
	 *
	 * @return the fec registro
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecRegistro() {
		return this.fecRegistro;
	}

	/**
	 * Method 'setFecRegistro'.
	 * 
	 * fecRegistro Date
	 *
	 * @param fecRegistro
	 *            the new fec registro
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecRegistro(Date fecRegistro) {
		this.fecRegistro = fecRegistro;
	}

	/**
	 * Method 'getIdDatosEnvioPostal069'.
	 * 
	 * Long
	 *
	 * @return the id datos envio postal 069
	 */

	public Long getIdDatosEnvioPostal069() {
		return this.idDatosEnvioPostal069;
	}

	/**
	 * Method 'setIdDatosEnvioPostal069'.
	 * 
	 * idDatosEnvioPostal069 Long
	 *
	 * @param idDatosEnvioPostal069
	 *            the new id datos envio postal 069
	 */

	public void setIdDatosEnvioPostal069(Long idDatosEnvioPostal069) {
		this.idDatosEnvioPostal069 = idDatosEnvioPostal069;
	}

	/**
	 * Method 'getIdRemesa069'.
	 * 
	 * Long
	 *
	 * @return the id remesa 069
	 */

	public Long getIdRemesa069() {
		return this.idRemesa069;
	}

	/**
	 * Method 'setIdRemesa069'.
	 * 
	 * idRemesa069 Long
	 *
	 * @param idRemesa069
	 *            the new id remesa 069
	 */

	public void setIdRemesa069(Long idRemesa069) {
		this.idRemesa069 = idRemesa069;
	}

	/**
	 * Method 'getCodRemesa069'.
	 * 
	 * String
	 *
	 * @return the cod remesa 069
	 */

	public String getCodRemesa069() {
		return this.codRemesa069;
	}

	/**
	 * Method 'setCodRemesa069'.
	 * 
	 * codRemesa069 String
	 *
	 * @param codRemesa069
	 *            the new cod remesa 069
	 */

	public void setCodRemesa069(String codRemesa069) {
		this.codRemesa069 = codRemesa069;
	}

	/**
	 * Method 'getIdColeccion069'.
	 * 
	 * Long
	 *
	 * @return the id coleccion 069
	 */

	public Long getIdColeccion069() {
		return this.idColeccion069;
	}

	/**
	 * Method 'setIdColeccion069'.
	 * 
	 * idColeccion069 Long
	 *
	 * @param idColeccion069
	 *            the new id coleccion 069
	 */

	public void setIdColeccion069(Long idColeccion069) {
		this.idColeccion069 = idColeccion069;
	}

	/**
	 * Method 'getCodColeccion069'.
	 * 
	 * String
	 *
	 * @return the cod coleccion 069
	 */

	public String getCodColeccion069() {
		return this.codColeccion069;
	}

	/**
	 * Method 'setCodColeccion069'.
	 * 
	 * codColeccion069 String
	 *
	 * @param codColeccion069
	 *            the new cod coleccion 069
	 */

	public void setCodColeccion069(String codColeccion069) {
		this.codColeccion069 = codColeccion069;
	}

	/**
	 * Method 'getIdEnvio069'.
	 * 
	 * Long
	 *
	 * @return the id envio 069
	 */

	public Long getIdEnvio069() {
		return this.idEnvio069;
	}

	/**
	 * Method 'setIdEnvio069'.
	 * 
	 * idEnvio069 Long
	 *
	 * @param idEnvio069
	 *            the new id envio 069
	 */

	public void setIdEnvio069(Long idEnvio069) {
		this.idEnvio069 = idEnvio069;
	}

	/**
	 * Method 'getCodEnvio069'.
	 * 
	 * String
	 *
	 * @return the cod envio 069
	 */

	public String getCodEnvio069() {
		return this.codEnvio069;
	}

	/**
	 * Method 'setCodEnvio069'.
	 * 
	 * codEnvio069 String
	 *
	 * @param codEnvio069
	 *            the new cod envio 069
	 */

	public void setCodEnvio069(String codEnvio069) {
		this.codEnvio069 = codEnvio069;
	}

	/**
	 * Method 'getCodSituacionEnvio069'.
	 * 
	 * String
	 *
	 * @return the cod situacion envio 069
	 */

	public String getCodSituacionEnvio069() {
		return this.codSituacionEnvio069;
	}

	/**
	 * Method 'setCodSituacionEnvio069'.
	 * 
	 * codSituacionEnvio069 String
	 *
	 * @param codSituacionEnvio069
	 *            the new cod situacion envio 069
	 */

	public void setCodSituacionEnvio069(String codSituacionEnvio069) {
		this.codSituacionEnvio069 = codSituacionEnvio069;
	}

	/**
	 * Method 'getDescSituacionEnvioEs069'.
	 * 
	 * String
	 *
	 * @return the desc situacion envio es 069
	 */

	public String getDescSituacionEnvioEs069() {
		return this.descSituacionEnvioEs069;
	}

	/**
	 * Method 'setDescSituacionEnvioEs069'.
	 * 
	 * descSituacionEnvioEs069 String
	 *
	 * @param descSituacionEnvioEs069
	 *            the new desc situacion envio es 069
	 */

	public void setDescSituacionEnvioEs069(String descSituacionEnvioEs069) {
		this.descSituacionEnvioEs069 = descSituacionEnvioEs069;
	}

	/**
	 * Method 'getDescSituacionEnvioEu069'.
	 * 
	 * String
	 *
	 * @return the desc situacion envio eu 069
	 */

	public String getDescSituacionEnvioEu069() {
		return this.descSituacionEnvioEu069;
	}

	/**
	 * Method 'setDescSituacionEnvioEu069'.
	 * 
	 * descSituacionEnvioEu069 String
	 *
	 * @param descSituacionEnvioEu069
	 *            the new desc situacion envio eu 069
	 */

	public void setDescSituacionEnvioEu069(String descSituacionEnvioEu069) {
		this.descSituacionEnvioEu069 = descSituacionEnvioEu069;
	}

	/**
	 * Method 'getEstadoEnvio069'.
	 * 
	 * String
	 *
	 * @return the estado envio 069
	 */

	public String getEstadoEnvio069() {
		return this.estadoEnvio069;
	}

	/**
	 * Method 'setEstadoEnvio069'.
	 * 
	 * estadoEnvio069 String
	 *
	 * @param estadoEnvio069
	 *            the new estado envio 069
	 */

	public void setEstadoEnvio069(String estadoEnvio069) {
		this.estadoEnvio069 = estadoEnvio069;
	}

	/**
	 * Method 'getDescEstadoEnvioEs'.
	 * 
	 * String
	 *
	 * @return the desc estado envio es
	 */

	public String getDescEstadoEnvioEs() {
		return this.descEstadoEnvioEs;
	}

	/**
	 * Method 'setDescEstadoEnvioEs'.
	 * 
	 * descEstadoEnvioEs String
	 *
	 * @param descEstadoEnvioEs
	 *            the new desc estado envio es
	 */

	public void setDescEstadoEnvioEs(String descEstadoEnvioEs) {
		this.descEstadoEnvioEs = descEstadoEnvioEs;
	}

	/**
	 * Method 'getDescEstadoEnvioEu'.
	 * 
	 * String
	 *
	 * @return the desc estado envio eu
	 */

	public String getDescEstadoEnvioEu() {
		return this.descEstadoEnvioEu;
	}

	/**
	 * Method 'setDescEstadoEnvioEu'.
	 * 
	 * descEstadoEnvioEu String
	 *
	 * @param descEstadoEnvioEu
	 *            the new desc estado envio eu
	 */

	public void setDescEstadoEnvioEu(String descEstadoEnvioEu) {
		this.descEstadoEnvioEu = descEstadoEnvioEu;
	}

	/**
	 * Method 'getFecnotificacion069'.
	 * 
	 * Date
	 *
	 * @return the fecnotificacion 069
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecnotificacion069() {
		return this.fecnotificacion069;
	}

	/**
	 * Method 'setFecnotificacion069'.
	 * 
	 * fecnotificacion069 Date
	 *
	 * @param fecnotificacion069
	 *            the new fecnotificacion 069
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecnotificacion069(Date fecnotificacion069) {
		this.fecnotificacion069 = fecnotificacion069;
	}

	/**
	 * Method 'getFecSituacionEnvio069'.
	 * 
	 * Date
	 *
	 * @return the fec situacion envio 069
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecSituacionEnvio069() {
		return this.fecSituacionEnvio069;
	}

	/**
	 * Method 'setFecSituacionEnvio069'.
	 * 
	 * fecSituacionEnvio069 Date
	 *
	 * @param fecSituacionEnvio069
	 *            the new fec situacion envio 069
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecSituacionEnvio069(Date fecSituacionEnvio069) {
		this.fecSituacionEnvio069 = fecSituacionEnvio069;
	}

	/**
	 * Method 'getFecacuse069'.
	 * 
	 * Date
	 *
	 * @return the fecacuse 069
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecacuse069() {
		return this.fecacuse069;
	}

	/**
	 * Method 'setFecacuse069'.
	 * 
	 * fecacuse069 Date
	 *
	 * @param fecacuse069
	 *            the new fecacuse 069
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecacuse069(Date fecacuse069) {
		this.fecacuse069 = fecacuse069;
	}

	/**
	 * Method 'getIdTramite089'.
	 * 
	 * Long
	 *
	 * @return the id tramite 089
	 */

	public Long getIdTramite089() {
		return this.idTramite089;
	}

	/**
	 * Method 'setIdTramite089'.
	 * 
	 * idTramite089 Long
	 *
	 * @param idTramite089
	 *            the new id tramite 089
	 */

	public void setIdTramite089(Long idTramite089) {
		this.idTramite089 = idTramite089;
	}

	/**
	 * Method 'getDescripcionEs089'.
	 * 
	 * String
	 *
	 * @return the descripcion es 089
	 */

	public String getDescripcionEs089() {
		return this.descripcionEs089;
	}

	/**
	 * Method 'setDescripcionEs089'.
	 * 
	 * descripcionEs089 String
	 *
	 * @param descripcionEs089
	 *            the new descripcion es 089
	 */

	public void setDescripcionEs089(String descripcionEs089) {
		this.descripcionEs089 = descripcionEs089;
	}

	/**
	 * Method 'getDescripcionEu089'.
	 * 
	 * String
	 *
	 * @return the descripcion eu 089
	 */

	public String getDescripcionEu089() {
		return this.descripcionEu089;
	}

	/**
	 * Method 'setDescripcionEu089'.
	 * 
	 * descripcionEu089 String
	 *
	 * @param descripcionEu089
	 *            the new descripcion eu 089
	 */

	public void setDescripcionEu089(String descripcionEu089) {
		this.descripcionEu089 = descripcionEu089;
	}

	/**
	 * Method 'getCodDatosNotif066'.
	 * 
	 * Integer
	 *
	 * @return the cod datos notif 066
	 */

	public Integer getCodDatosNotif066() {
		return this.codDatosNotif066;
	}

	/**
	 * Method 'setCodDatosNotif066'.
	 * 
	 * codDatosNotif066 Integer
	 *
	 * @param codDatosNotif066
	 *            the new cod datos notif 066
	 */

	public void setCodDatosNotif066(Integer codDatosNotif066) {
		this.codDatosNotif066 = codDatosNotif066;
	}

	/**
	 * Method 'getCodLocalizacion067'.
	 * 
	 * Integer
	 *
	 * @return the cod localizacion 067
	 */

	public Integer getCodLocalizacion067() {
		return this.codLocalizacion067;
	}

	/**
	 * Method 'setCodLocalizacion067'.
	 * 
	 * codLocalizacion067 Integer
	 *
	 * @param codLocalizacion067
	 *            the new cod localizacion 067
	 */

	public void setCodLocalizacion067(Integer codLocalizacion067) {
		this.codLocalizacion067 = codLocalizacion067;
	}

	/**
	 * Method 'getDescProvincia'.
	 * 
	 * String
	 *
	 * @return the desc provincia
	 */

	public String getDescProvincia() {
		return this.descProvincia;
	}

	/**
	 * Method 'setDescProvincia'.
	 * 
	 * descProvincia String
	 *
	 * @param descProvincia
	 *            the new desc provincia
	 */

	public void setDescProvincia(String descProvincia) {
		this.descProvincia = descProvincia;
	}

	/**
	 * Method 'getDescMunicipio'.
	 * 
	 * String
	 *
	 * @return the desc municipio
	 */

	public String getDescMunicipio() {
		return this.descMunicipio;
	}

	/**
	 * Method 'setDescMunicipio'.
	 * 
	 * descMunicipio String
	 *
	 * @param descMunicipio
	 *            the new desc municipio
	 */

	public void setDescMunicipio(String descMunicipio) {
		this.descMunicipio = descMunicipio;
	}

	/**
	 * Method 'getDescLocalidad'.
	 * 
	 * String
	 *
	 * @return the desc localidad
	 */

	public String getDescLocalidad() {
		return this.descLocalidad;
	}

	/**
	 * Method 'setDescLocalidad'.
	 * 
	 * descLocalidad String
	 *
	 * @param descLocalidad
	 *            the new desc localidad
	 */

	public void setDescLocalidad(String descLocalidad) {
		this.descLocalidad = descLocalidad;
	}

	/**
	 * Method 'getCalle067'.
	 * 
	 * String
	 *
	 * @return the calle 067
	 */

	public String getCalle067() {
		return this.calle067;
	}

	/**
	 * Method 'setCalle067'.
	 * 
	 * calle067 String
	 *
	 * @param calle067
	 *            the new calle 067
	 */

	public void setCalle067(String calle067) {
		this.calle067 = calle067;
	}

	/**
	 * Method 'getPortal067'.
	 * 
	 * String
	 *
	 * @return the portal 067
	 */

	public String getPortal067() {
		return this.portal067;
	}

	/**
	 * Method 'setPortal067'.
	 * 
	 * portal067 String
	 *
	 * @param portal067
	 *            the new portal 067
	 */

	public void setPortal067(String portal067) {
		this.portal067 = portal067;
	}

	/**
	 * Method 'getCodpostal067'.
	 * 
	 * String
	 *
	 * @return the codpostal 067
	 */

	public String getCodpostal067() {
		return this.codpostal067;
	}

	/**
	 * Method 'setCodpostal067'.
	 * 
	 * codpostal067 String
	 *
	 * @param codpostal067
	 *            the new codpostal 067
	 */

	public void setCodpostal067(String codpostal067) {
		this.codpostal067 = codpostal067;
	}

	/**
	 * Method 'getPiso067'.
	 * 
	 * String
	 *
	 * @return the piso 067
	 */

	public String getPiso067() {
		return this.piso067;
	}

	/**
	 * Method 'setPiso067'.
	 * 
	 * piso067 String
	 *
	 * @param piso067
	 *            the new piso 067
	 */

	public void setPiso067(String piso067) {
		this.piso067 = piso067;
	}

	/**
	 * Method 'getPuerta067'.
	 * 
	 * String
	 *
	 * @return the puerta 067
	 */

	public String getPuerta067() {
		return this.puerta067;
	}

	/**
	 * Method 'setPuerta067'.
	 * 
	 * puerta067 String
	 *
	 * @param puerta067
	 *            the new puerta 067
	 */

	public void setPuerta067(String puerta067) {
		this.puerta067 = puerta067;
	}

	/**
	 * Method 'getTramite'.
	 * 
	 * tramite
	 *
	 * @return the tramite
	 */

	public Tramite getTramite() {
		return this.tramite;
	}

	/**
	 * Method 'setTramite'.
	 * 
	 * tramite Tramite
	 *
	 * @param tramite
	 *            the new tramite
	 */

	public void setTramite(Tramite tramite) {
		this.tramite = tramite;
	}

	/**
	 * Gets the apertura.
	 * 
	 * the apertura
	 *
	 * @return the apertura
	 */
	public ComunicacionApertura getApertura() {
		return this.apertura;
	}

	/**
	 * Sets the apertura.
	 * 
	 * apertura the apertura to set
	 *
	 * @param apertura
	 *            the new apertura
	 */
	public void setApertura(ComunicacionApertura apertura) {
		this.apertura = apertura;
	}

	/**
	 * Gets the os 2.
	 * 
	 * the os2
	 *
	 * @return the os 2
	 */
	public OS2 getOs2() {
		return this.os2;
	}

	/**
	 * Sets the os 2.
	 * 
	 * os2 the os2 to set
	 *
	 * @param os2
	 *            the new os 2
	 */
	public void setOs2(OS2 os2) {
		this.os2 = os2;
	}

	/**
	 * Gets the os 3.
	 * 
	 * the os3
	 *
	 * @return the os 3
	 */
	public OS3 getOs3() {
		return this.os3;
	}

	/**
	 * Sets the os 3.
	 * 
	 * os3 the os3 to set
	 *
	 * @param os3
	 *            the new os 3
	 */
	public void setOs3(OS3 os3) {
		this.os3 = os3;
	}

	/**
	 * Gets the datos envio postal.
	 * 
	 * the datosEnvioPostal
	 *
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal getDatosEnvioPostal() {
		return this.datosEnvioPostal;
	}

	/**
	 * Sets the datos envio postal.
	 * 
	 * datosEnvioPostal the datosEnvioPostal to set
	 *
	 * @param datosEnvioPostal
	 *            the new datos envio postal
	 */
	public void setDatosEnvioPostal(DatosEnvioPostal datosEnvioPostal) {
		this.datosEnvioPostal = datosEnvioPostal;
	}

	/**
	 * Gets the datos notif envio.
	 * 
	 * the datosNotifEnvio
	 *
	 * @return the datos notif envio
	 */
	public DatosNotificacion getDatosNotifEnvio() {
		return this.datosNotifEnvio;
	}

	/**
	 * Sets the datos notif envio.
	 * 
	 * datosNotifEnvio the datosNotifEnvio to set
	 *
	 * @param datosNotifEnvio
	 *            the new datos notif envio
	 */
	public void setDatosNotifEnvio(DatosNotificacion datosNotifEnvio) {
		this.datosNotifEnvio = datosNotifEnvio;
	}

	/**
	 * Checks if is es situacion final.
	 * 
	 * boolean
	 *
	 * @return true, if is es situacion final
	 */
	public boolean isEsSituacionFinal() {
		return this.esSituacionFinal;
	}

	/**
	 * Sets the es situacion final.
	 * 
	 * esSituacionFinal boolean
	 *
	 * @param esSituacionFinal
	 *            the new es situacion final
	 */
	public void setEsSituacionFinal(boolean esSituacionFinal) {
		this.esSituacionFinal = esSituacionFinal;
	}

	/**
	 * Checks if is es envio correcto.
	 * 
	 * boolean
	 *
	 * @return the boolean
	 */
	public Boolean isEsEnvioCorrecto() {
		return this.esEnvioCorrecto;
	}

	/**
	 * Sets the es envio correcto.
	 * 
	 * esEnvioCorrecto Boolean
	 *
	 * @param esEnvioCorrecto
	 *            the new es envio correcto
	 */
	public void setEsEnvioCorrecto(Boolean esEnvioCorrecto) {
		this.esEnvioCorrecto = esEnvioCorrecto;
	}

	/**
	 * Gets the fec registro desde.
	 * 
	 * the fecRegistroDesde
	 *
	 * @return the fec registro desde
	 */
	public Date getFecRegistroDesde() {
		return this.fecRegistroDesde;
	}

	/**
	 * Sets the fec registro desde.
	 * 
	 * fecRegistroDesde the fecRegistroDesde to set
	 *
	 * @param fecRegistroDesde
	 *            the new fec registro desde
	 */
	public void setFecRegistroDesde(Date fecRegistroDesde) {
		this.fecRegistroDesde = fecRegistroDesde;
	}

	/**
	 * Gets the fec registro hasta.
	 * 
	 * the fecRegistroHasta
	 *
	 * @return the fec registro hasta
	 */
	public Date getFecRegistroHasta() {
		return this.fecRegistroHasta;
	}

	/**
	 * Sets the fec registro hasta.
	 * 
	 * fecRegistroHasta the fecRegistroHasta to set
	 *
	 * @param fecRegistroHasta
	 *            the new fec registro hasta
	 */
	public void setFecRegistroHasta(Date fecRegistroHasta) {
		this.fecRegistroHasta = fecRegistroHasta;
	}

	/**
	 * Gets the comunicaciones total.
	 * 
	 * the comunicacionesTotal
	 *
	 * @return the comunicaciones total
	 */
	public Integer getComunicacionesTotal() {
		int total = 0;
		if (this.estadosComunicaciones != null) {
			for (int cont = 0; cont < this.estadosComunicaciones.length; cont++) {
				if (this.estadosComunicaciones[cont] != null) {
					total += this.estadosComunicaciones[cont].intValue();
				}
			}
		}

		return Integer.valueOf(total);
	}

	/**
	 * Gets the estados comunicaciones.
	 * 
	 * the estadosComunicaciones
	 *
	 * @return the estados comunicaciones
	 */
	public Integer[] getEstadosComunicaciones() {
		return this.estadosComunicaciones;
	}

	/**
	 * Sets the estados comunicaciones.
	 * 
	 * estadosComunicaciones the estadosComunicaciones to set
	 *
	 * @param estadosComunicaciones
	 *            the new estados comunicaciones
	 */
	public void setEstadosComunicaciones(Integer[] estadosComunicaciones) {
		this.estadosComunicaciones = estadosComunicaciones;
	}

	/**
	 * Gets the tiposexp.
	 * 
	 * the tiposexp
	 *
	 * @return the tiposexp
	 */
	public String[] getTiposexp() {
		return tiposexp;
	}

	/**
	 * Sets the tiposexp.
	 * 
	 * tiposexp the tiposexp to set
	 *
	 * @param tiposexp
	 *            the new tiposexp
	 */
	public void setTiposexp(String[] tiposexp) {
		this.tiposexp = tiposexp;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * String
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta

		result.append("[ tipoexp: ").append(this.tipoexp).append(" ]");

		result.append(", [ idTramite: ").append(this.idTramite).append(" ]");

		result.append(", [ tipoTramite: ").append(this.tipoTramite)
				.append(" ]");

		result.append(", [ territApertura: ").append(this.territApertura)
				.append(" ]");

		result.append(", [ anoApertura: ").append(this.anoApertura)
				.append(" ]");

		result.append(", [ numApertura: ").append(this.numApertura)
				.append(" ]");

		result.append(", [ fecRegistro: ").append(this.fecRegistro)
				.append(" ]");

		result.append(", [ idDatosEnvioPostal069: ")
				.append(this.idDatosEnvioPostal069).append(" ]");

		result.append(", [ idRemesa069: ").append(this.idRemesa069)
				.append(" ]");

		result.append(", [ codRemesa069: ").append(this.codRemesa069)
				.append(" ]");

		result.append(", [ idColeccion069: ").append(this.idColeccion069)
				.append(" ]");

		result.append(", [ codColeccion069: ").append(this.codColeccion069)
				.append(" ]");

		result.append(", [ idEnvio069: ").append(this.idEnvio069).append(" ]");

		result.append(", [ codEnvio069: ").append(this.codEnvio069)
				.append(" ]");

		result.append(", [ codSituacionEnvio069: ")
				.append(this.codSituacionEnvio069).append(" ]");

		result.append(", [ descSituacionEnvioEs069: ")
				.append(this.descSituacionEnvioEs069).append(" ]");

		result.append(", [ descSituacionEnvioEu069: ")
				.append(this.descSituacionEnvioEu069).append(" ]");

		result.append(", [ estadoEnvio069: ").append(this.estadoEnvio069)
				.append(" ]");

		result.append(", [ descEstadoEnvioEs: ").append(this.descEstadoEnvioEs)
				.append(" ]");

		result.append(", [ descEstadoEnvioEu: ").append(this.descEstadoEnvioEu)
				.append(" ]");

		result.append(", [ fecnotificacion069: ")
				.append(this.fecnotificacion069).append(" ]");

		result.append(", [ fecSituacionEnvio069: ")
				.append(this.fecSituacionEnvio069).append(" ]");

		result.append(", [ fecacuse069: ").append(this.fecacuse069)
				.append(" ]");

		result.append(", [ idTramite089: ").append(this.idTramite089)
				.append(" ]");

		result.append(", [ descripcionEs089: ").append(this.descripcionEs089)
				.append(" ]");

		result.append(", [ descripcionEu089: ").append(this.descripcionEu089)
				.append(" ]");

		result.append(", [ codDatosNotif066: ").append(this.codDatosNotif066)
				.append(" ]");

		result.append(", [ codLocalizacion067: ")
				.append(this.codLocalizacion067).append(" ]");

		result.append(", [ descProvincia: ").append(this.descProvincia)
				.append(" ]");

		result.append(", [ descMunicipio: ").append(this.descMunicipio)
				.append(" ]");

		result.append(", [ descLocalidad: ").append(this.descLocalidad)
				.append(" ]");

		result.append(", [ calle067: ").append(this.calle067).append(" ]");

		result.append(", [ portal067: ").append(this.portal067).append(" ]");

		result.append(", [ codpostal067: ").append(this.codpostal067)
				.append(" ]");

		result.append(", [ piso067: ").append(this.piso067).append(" ]");

		result.append(", [ puerta067: ").append(this.puerta067).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Gets the id envio estado envio.
	 * 
	 * the idEnvioEstadoEnvio
	 *
	 * @return the id envio estado envio
	 */
	public String getIdEnvioEstadoEnvio() {
		StringBuilder sb = new StringBuilder();
		if (this.datosEnvioPostal != null) {
			sb.append(this.datosEnvioPostal.getIdEnvio069());
			// sb.append(this.datosEnvioPostal.getCodEnvio069());
			sb.append(Constantes.SEPARADOR_ALMOHADILLAS);
			sb.append(this.datosEnvioPostal.getEstadoEnvio069());
			sb.append(Constantes.SEPARADOR_ALMOHADILLAS);
			sb.append(this.tipoexp);
			sb.append(Constantes.SEPARADOR_ALMOHADILLAS);
			sb.append(this.idTramite);
			sb.append(Constantes.SEPARADOR_ALMOHADILLAS);
			sb.append(SituacionEntregaEnum
					.getByCodSituacion(
							this.datosEnvioPostal.getCodSituacionEnvio069())
					.esSituacionFinal());
			sb.append(Constantes.SEPARADOR_ALMOHADILLAS);
			sb.append(this.oid);
		}
		return sb.toString();
	}

	/**
	 * Gets the oid.
	 * 
	 * the oid
	 *
	 * @return the oid
	 */
	public String getOid() {
		return oid;
	}

	/**
	 * Sets the oid.
	 * 
	 * oid the new oid
	 *
	 * @param oid
	 *            the new oid
	 */
	public void setOid(String oid) {
		this.oid = oid;
	}
}
